#ifndef _CreateNewDB_CPP
#define _CreateNewDB_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <Stdio.H>
#include <Stdlib.H>
#include <CommCtrl.h>

#include "../Resources/Resource.H"

#include "../CSockSrvr/CSockSrvr.H"

#include "../../SharedSource/NSWFL.H"
#include "../Source/Entry.H"
#include "../Source/Routines.H"
#include "../Source/NewDB.H"

#include "../Dialogs/MainDlg.H"
#include "../Dialogs/CreateNewDB.H"
#include "../../SharedClasses/CStatusDlg/CStatusDlg.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//---------------------(Variable Declarations)
HWND CreateNewDB_hWnd = NULL;

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL CALLBACK CreateNewDBDialog(HWND xHandle, UINT xMessage, WPARAM wParam, LPARAM lParam)
{
    //--------------------------------------------------------------------------

	static HWND BackupName_hWnd = NULL;
	static HWND NewDBName_hWnd = NULL;
	static HWND DBO_hWnd = NULL;
	static HWND DataFileLOC_hWnd = NULL;

    //--------------------------------------------------------------------------

    if(xMessage == WM_INITDIALOG)
    {
        CreateNewDB_hWnd = xHandle;

        char sCaption[1024];
		sprintf(sCaption, "%s :: %s", gsTitleCaption, "Create Database");
		SendMessage(xHandle, (UINT)WM_SETTEXT, (WPARAM)0, (LPARAM)sCaption);
        SendMessage(xHandle, WM_SETICON, TRUE, (LPARAM) LoadIcon(ghAppInstance, MAKEINTRESOURCE(IDI_TRAYICON)) );

		BackupName_hWnd  = GetDlgItem(xHandle, IDC_BACKUPNAME);
		NewDBName_hWnd   = GetDlgItem(xHandle, IDC_NEWDBNAME);
		DBO_hWnd         = GetDlgItem(xHandle, IDC_DBO);
		DataFileLOC_hWnd = GetDlgItem(xHandle, IDC_DATAFILELOC);

		Set_Text(DBO_hWnd, gsDefaultDBO);
		Set_Text(DataFileLOC_hWnd, gsSQLDataFiles);

		CenterWindow(xHandle);

        return TRUE;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_COMMAND)
    {
		if(wParam == IDC_CREATE)
        {
			char sBackupFile[MAX_PATH];
			char sNewDB[255];
			int iLen = 0;

			iLen = Get_TextEx(BackupName_hWnd, sBackupFile, sizeof(sBackupFile));
			if(iLen == 0 || iLen > sizeof(sBackupFile))
			{
				MsgBox("You must enter an existing backup file name.");
				return TRUE;
			}

			iLen = Get_TextEx(NewDBName_hWnd, sNewDB, sizeof(sNewDB));
			if(iLen == 0 || iLen > sizeof(sNewDB))
			{
				MsgBox("You must enter a name for the new Database.");
				return TRUE;
			}

			iLen = Get_TextEx(DataFileLOC_hWnd, gsSQLDataFiles, sizeof(gsSQLDataFiles));
			if(iLen == 0 || iLen > sizeof(gsSQLDataFiles))
			{
				MsgBox("You must enter a data file location.");
				return TRUE;
			}

			iLen = Get_TextEx(DBO_hWnd, gsDefaultDBO, sizeof(gsDefaultDBO));
			if(iLen == 0 || iLen > sizeof(gsDefaultDBO))
			{
				//MsgBox("You must enter a database owner.");
				//return TRUE;
			}

			CStatusDlg MyStatDlg;

			MyStatDlg.Load(NULL, "Setting up new client database.", IDI_MAIN, false);
			ShowWindow(xHandle, SW_HIDE);
			ShowWindow(MainDialog_hWnd, SW_HIDE);
			MyStatDlg.Show();

			if(SetupNewClient(sBackupFile, gsDefaultDBO, sNewDB, true, true, true, &MyStatDlg))
			{
				MsgBox("New database creation complete!");
				EndDialog(xHandle,0);
			}

			MyStatDlg.SetButtonText("Ok");

			MyStatDlg.EnableButton();

			while(MyStatDlg.IsDlgVisible())
			{
				Sleep(1);
			}

			MyStatDlg.Unload();
			ShowWindow(MainDialog_hWnd, SW_SHOW);
			ShowWindow(xHandle, SW_SHOW);

			SetForegroundWindow(xHandle);

			return TRUE;
        }

        if(wParam == IDC_CANCEL)
        {
			EndDialog(xHandle,0);
			DestroyWindow(xHandle);
			return TRUE;
        }

		
		return FALSE;
    }

	//--------------------------------------------------------------------------

	if(xMessage == WM_PAINT)
    {
        HDC ThisHDC;
        PAINTSTRUCT ThisPS;

        ThisHDC = BeginPaint(xHandle, &ThisPS);

        // Any painting should be done here

        EndPaint(xHandle, &ThisPS);
        return TRUE;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_CLOSE) 
    {
        EndDialog(xHandle,0);
        DestroyWindow(xHandle);
        return TRUE;
    }

    //--------------------------------------------------------------------------

    return FALSE;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif

